export interface Product {
    id: string;
    name: string;
    category: "Phones" | "Accessories" | "Audio" | "Smart Devices" | "Others";
    price: number;
    image: string;
    description: string;
    inStock: boolean;
}

export interface CartItem extends Product {
    quantity: number;
}

export interface User {
    id: string;
    name: string;
    email: string;
    role: "customer" | "admin";
}

export interface Order {
    id: string;
    userId: string;
    items: CartItem[];
    total: number;
    status: "pending" | "processing" | "shipped" | "delivered";
    createdAt: string;
}
