"use client";
import React, { createContext, useContext, useState, useEffect } from "react";
import { User } from "@/types";

interface AuthContextType {
    user: User | null;
    login: (email: string, password: string) => Promise<void>;
    signup: (name: string, email: string, password: string) => Promise<void>;
    logout: () => void;
    isLoading: boolean;
}

const AuthContext = createContext<AuthContextType | undefined>(undefined);

export function AuthProvider({ children }: { children: React.ReactNode }) {
    const [user, setUser] = useState<User | null>(null);
    const [isLoading, setIsLoading] = useState(true);

    useEffect(() => {
        const saved = localStorage.getItem("user");
        if (saved) {
            try {
                const parsedUser = JSON.parse(saved);
                // Re-evaluate role on load to catch permission updates
                if (parsedUser.email === "admin@chigoexpress.com" || parsedUser.email === "chigoziemediahouse@gmail.com") {
                    parsedUser.role = "admin";
                }
                setUser(parsedUser);
            } catch (e) { console.error(e) }
        }
        setIsLoading(false);
    }, []);

    const login = async (email: string, pass: string) => {
        setIsLoading(true);
        // Mock API call
        return new Promise<void>((resolve, reject) => {
            setTimeout(() => {
                if (email.includes("@")) { // Simple validation
                    const mockUser: User = {
                        id: "123",
                        name: email.split("@")[0],
                        email,
                        role: (email === "chigoziemediahouse@gmail.com" || email === "admin@chigoexpress.com") ? "admin" : "customer"
                    };
                    setUser(mockUser);
                    localStorage.setItem("user", JSON.stringify(mockUser));
                    resolve();
                } else {
                    reject(new Error("Invalid credentials"));
                }
                setIsLoading(false);
            }, 1000);
        });
    };

    const signup = async (name: string, email: string, pass: string) => {
        setIsLoading(true);
        return new Promise<void>((resolve) => {
            setTimeout(() => {
                const mockUser: User = { id: Date.now().toString(), name, email, role: "customer" };
                setUser(mockUser);
                localStorage.setItem("user", JSON.stringify(mockUser));
                setIsLoading(false);
                resolve();
            }, 1000);
        });
    };

    const logout = () => {
        setUser(null);
        localStorage.removeItem("user");
    };

    return (
        <AuthContext.Provider value={{ user, login, signup, logout, isLoading }}>
            {children}
        </AuthContext.Provider>
    );
}

export const useAuth = () => {
    const context = useContext(AuthContext);
    if (!context) throw new Error("useAuth must be used within AuthProvider");
    return context;
};
