"use client";
import React, { useState, useEffect } from "react";
import { loadStripe } from "@stripe/stripe-js";
import { Elements } from "@stripe/react-stripe-js";
import StripePaymentForm from "./StripePaymentForm";
import styles from "@/app/checkout/page.module.css";

// Make sure to call loadStripe outside of a component’s render to avoid
// recreating the Stripe object on every render.
const stripePromise = loadStripe(process.env.NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY || "pk_test_sample_key");

export default function StripeWrapper({ amount }: { amount: number }) {
    const [clientSecret, setClientSecret] = useState("");

    useEffect(() => {
        // Create PaymentIntent as soon as the page loads
        fetch("/api/create-payment-intent", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ amount: amount }),
        })
            .then((res) => res.json())
            .then((data) => setClientSecret(data.clientSecret));
    }, [amount]);

    const appearance = {
        theme: 'stripe' as const,
        variables: {
            colorPrimary: '#ff9800',
        },
    };
    const options = {
        clientSecret,
        appearance,
    };

    return (
        <div className={styles.stripeWrapper}>
            {clientSecret && (
                <Elements options={options} stripe={stripePromise}>
                    <StripePaymentForm amount={amount} />
                </Elements>
            )}
        </div>
    );
}
