"use client";
import React from "react";
import { X, ShoppingCart } from "lucide-react";
import styles from "./ProductDetailsModal.module.css";
import { Product } from "@/types";
import { useCart } from "@/context/CartContext";

interface ProductDetailsModalProps {
    product: Product | null;
    isOpen: boolean;
    onClose: () => void;
}

export default function ProductDetailsModal({ product, isOpen, onClose }: ProductDetailsModalProps) {
    const { addItem } = useCart();

    if (!isOpen || !product) return null;

    return (
        <div className={styles.overlay} onClick={onClose}>
            <div className={styles.modal} onClick={(e) => e.stopPropagation()}>
                <button className={styles.closeBtn} onClick={onClose}>
                    <X size={24} />
                </button>

                <div className={styles.imageSection}>
                    <img src={product.image} alt={product.name} className={styles.image} />
                </div>

                <div className={styles.infoSection}>
                    <span className={styles.category}>{product.category}</span>
                    <h2 className={styles.title}>{product.name}</h2>
                    <div className={styles.price}>${product.price.toLocaleString()}</div>

                    <p className={styles.description}>
                        {product.description || "Experience premium quality with this authentic product from ChiggaExpress."}
                    </p>

                    <button
                        className={styles.addToCartBtn}
                        onClick={() => {
                            addItem(product);
                            onClose();
                        }}
                    >
                        <ShoppingCart size={20} />
                        Add to Cart
                    </button>
                </div>
            </div>
        </div>
    );
}
