"use client";
import React, { useState } from "react";
import { X, FileText } from "lucide-react";
import styles from "./ProductDescription.module.css";

interface ProductDescriptionProps {
    description: string;
}

export default function ProductDescription({ description }: ProductDescriptionProps) {
    const [isOpen, setIsOpen] = useState(false);

    return (
        <>
            <button className={styles.triggerBtn} onClick={() => setIsOpen(true)}>
                <FileText size={18} /> View Description
            </button>

            {isOpen && (
                <div className={styles.overlay} onClick={() => setIsOpen(false)}>
                    <div className={styles.modal} onClick={e => e.stopPropagation()}>
                        <div className={styles.header}>
                            <h3>Description</h3>
                            <button className={styles.closeBtn} onClick={() => setIsOpen(false)}>
                                <X size={24} />
                            </button>
                        </div>
                        <div className={styles.content}>
                            <p>{description}</p>
                        </div>
                    </div>
                </div>
            )}
        </>
    );
}
