"use client";
import React from "react";
import Link from "next/link";
import { Plus } from "lucide-react";
import styles from "./ProductCard.module.css";
import { Product } from "@/types";
import { useCart } from "@/context/CartContext";

interface ProductCardProps {
    product: Product;
    onClick?: () => void;
}

export default function ProductCard({ product, onClick }: ProductCardProps) {
    const { addItem } = useCart();

    const handleClick = (e: React.MouseEvent) => {
        if (onClick) {
            e.preventDefault();
            onClick();
        }
    };

    return (
        <div className={styles.card}>
            <Link
                href={`/product/${product.id}`}
                className={styles.cardLink}
                onClick={handleClick}
            >
                <div className={styles.imageWrapper}>
                    <img src={product.image} alt={product.name} className={styles.image} />
                </div>
                <div className={styles.content}>
                    <span className={styles.category}>{product.category}</span>
                    <h3 className={styles.title}>{product.name}</h3>
                    <div className={styles.footer}>
                        <span className={styles.price}>${product.price}</span>
                    </div>
                </div>
            </Link>
            <button
                className={styles.addBtn}
                onClick={(e) => {
                    e.preventDefault();
                    addItem(product);
                }}
                aria-label="Add to cart"
            >
                <Plus size={20} />
            </button>
        </div>
    );
}
