"use client";
import React, { useState } from "react";
import Link from "next/link";
import { ShoppingCart, User, Menu, X } from "lucide-react";
import styles from "./Navbar.module.css";
import { useCart } from "@/context/CartContext";

export default function Navbar() {
    const { count } = useCart();
    const [isMenuOpen, setIsMenuOpen] = useState(false);

    return (
        <header className={styles.header}>
            {/* Top Bar */}
            <div className={styles.topBar}>
                <div className={styles.container}>
                    <span>Free Shipping on Orders Over $50! 🚚</span>
                    <div className={styles.topLinks}>
                        <Link href="/contact">Need Help?</Link>
                        <Link href="/account">Join Us</Link>
                    </div>
                </div>
            </div>

            {/* Main Navbar */}
            <nav className={styles.navbar}>
                {/* Mobile Menu Button (Left on Mobile, Hidden on Desktop) */}
                <button
                    className={styles.mobileMenuBtn}
                    onClick={() => setIsMenuOpen(!isMenuOpen)}
                >
                    {isMenuOpen ? <X size={24} /> : <Menu size={24} />}
                </button>

                {/* Desktop Nav Links (Left) */}
                <div className={`${styles.navLinks} ${isMenuOpen ? styles.mobileOpen : ""}`}>
                    {/* Mobile Header in Menu */}
                    <div className={styles.mobileMenuHeader}>
                        <span>Menu</span>
                        <button onClick={() => setIsMenuOpen(false)}><X size={24} /></button>
                    </div>

                    <Link href="/" className={styles.navLink} onClick={() => setIsMenuOpen(false)}>Home</Link>
                    <Link href="/shop" className={styles.navLink} onClick={() => setIsMenuOpen(false)}>Shop</Link>
                    <Link href="/about" className={styles.navLink} onClick={() => setIsMenuOpen(false)}>About Us</Link>
                    <Link href="/contact" className={styles.navLink} onClick={() => setIsMenuOpen(false)}>Contact</Link>
                </div>

                {/* Logo (Center) */}
                <div className={styles.logo}>
                    <Link href="/">
                        <img src="/logo.png" alt="ChiggaExpress" className={styles.logoImg} />
                    </Link>
                </div>

                {/* Actions (Right) */}
                <div className={styles.actions}>
                    <Link href="/cart" className={styles.iconBtn}>
                        <ShoppingCart size={22} />
                        {count > 0 && <span className={styles.badge}>{count}</span>}
                    </Link>
                    <Link href="/account" className={styles.iconBtn}>
                        <User size={22} />
                    </Link>
                </div>
            </nav>

            {/* Overlay for Mobile Menu */}
            {isMenuOpen && <div className={styles.overlay} onClick={() => setIsMenuOpen(false)} />}
        </header>
    );
}
