import React from "react";
import Link from "next/link";
import styles from "./Footer.module.css";

export default function Footer() {
    return (
        <footer className={styles.footer}>
            <div className={styles.container}>
                <div className={styles.section}>
                    <h3 className={styles.heading}>ChiggaExpress</h3>
                    <p className={styles.text}>Your premium destination for electronics and gadgets.</p>
                </div>

                <div className={styles.section}>
                    <h4 className={styles.subHeading}>Shop</h4>
                    <Link href="/shop?cat=Phones" className={styles.link}>Phones</Link>
                    <Link href="/shop?cat=Audio" className={styles.link}>Audio</Link>
                    <Link href="/shop?cat=Accessories" className={styles.link}>Accessories</Link>
                </div>

                <div className={styles.section}>
                    <h4 className={styles.subHeading}>Support</h4>
                    <Link href="/contact" className={styles.link}>Contact Us</Link>
                    <Link href="/privacy" className={styles.link}>Privacy Policy</Link>
                    <Link href="/terms" className={styles.link}>Terms & Conditions</Link>
                </div>

                <div className={styles.section}>
                    <h4 className={styles.subHeading}>Contact</h4>
                    <p className={styles.text}>chigoziemediahouse@gmail.com</p>
                    <p className={styles.text}>+1 (405) 761-8287</p>
                </div>
            </div>
            <div className={styles.bottom}>
                <p>&copy; {new Date().getFullYear()} ChiggaExpress.com. All rights reserved.</p>
            </div>
        </footer>
    );
}
