"use client";
import React, { useState } from "react";
import { Plus, Minus, ShoppingCart } from "lucide-react";
import { useCart } from "@/context/CartContext";
import { Product } from "@/types";
import styles from "./AddToCart.module.css";

export default function AddToCart({ product }: { product: Product }) {
    const { addItem, updateQuantity, items } = useCart();
    // We can just use addItem for simplicity, or manage quantity here before adding.
    // For this flow, let's keep it simple: Add to cart button.

    const handleAdd = () => {
        addItem(product);
        // Optional: Show toast
    };

    return (
        <button className={styles.button} onClick={handleAdd}>
            <ShoppingCart size={20} /> Add to Cart
        </button>
    );
}
