import styles from "@/components/StaticPage.module.css";

export default function TermsPage() {
    return (
        <div className={styles.container}>
            <h1 className={styles.title}>Terms & Conditions</h1>

            <div className={styles.section}>
                <p className={styles.text}>By using ChiggaExpress.com, you agree to the following terms and conditions.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Use of Website</h2>
                <p className={styles.text}>You agree to use this website for lawful purposes only and not for any fraudulent or harmful activity.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Products & Pricing</h2>
                <p className={styles.text}>We strive to ensure all product descriptions, images, and prices are accurate. However, we reserve the right to correct errors or update information without prior notice.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Orders & Payments</h2>
                <p className={styles.text}>All orders are subject to availability and confirmation. Payments must be completed before orders are processed and shipped.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Returns & Refunds</h2>
                <p className={styles.text}>Return and refund policies will apply based on the condition of products and the reason for return. Please contact us for assistance.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Intellectual Property</h2>
                <p className={styles.text}>All content on this website, including images, logos, and text, belongs to ChiggaExpress.com and may not be used without permission.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Limitation of Liability</h2>
                <p className={styles.text}>ChiggaExpress.com is not liable for any indirect or consequential damages arising from the use of this website.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Contact Information</h2>
                <p className={styles.text}>For any questions regarding these Terms & Conditions, contact us:</p>
                <div className={styles.contactInfo}>
                    <p><strong>Email:</strong> chigoziemediahouse@gmail.com</p>
                    <p><strong>WhatsApp:</strong> +1 (405) 761-8287</p>
                    <p><strong>Address:</strong> 2444 West Eubanks Street, Oklahoma City, USA</p>
                </div>
            </div>
        </div>
    );
}
