import React from "react";
import styles from "./page.module.css";
import ProductCard from "@/components/ProductCard";
import { products, categories } from "@/data/products";
import Link from "next/link";
import { Filter } from "lucide-react";

// Server component to handle searchParams
export default async function ShopPage({
    searchParams,
}: {
    searchParams: Promise<{ cat?: string }>;
}) {
    const resolvedParams = await searchParams;
    const selectedCategory = resolvedParams.cat || "All";

    const filteredProducts =
        selectedCategory === "All"
            ? products
            : products.filter((p) => p.category === selectedCategory);

    return (
        <div className={styles.container}>
            <div className={styles.header}>
                <h1 className={styles.title}>Shop</h1>
                <p className={styles.subtitle}>Explore our premium collection.</p>
            </div>

            <div className={styles.layout}>
                <aside className={styles.sidebar}>
                    <div className={styles.filterTitle}>
                        <Filter size={18} /> Categories
                    </div>
                    <div className={styles.categoryList}>
                        {categories.map(cat => (
                            <Link
                                key={cat}
                                href={cat === "All" ? "/shop" : `/shop?cat=${cat}`}
                                className={`${styles.categoryItem} ${selectedCategory === cat ? styles.active : ""}`}
                            >
                                {cat}
                            </Link>
                        ))}
                    </div>
                </aside>

                <main className={styles.grid}>
                    {filteredProducts.length > 0 ? (
                        filteredProducts.map(product => (
                            <ProductCard key={product.id} product={product} />
                        ))
                    ) : (
                        <div className={styles.noResults}>
                            No products found in this category.
                        </div>
                    )}
                </main>
            </div>
        </div>
    );
}
