"use client";
import React, { useState } from "react";
import ProductCard from "@/components/ProductCard";
import ProductDetailsModal from "@/components/ProductDetailsModal";
import { Product } from "@/types";
import styles from "./page.module.css"; // Reuse existing styles
import { products, categories } from "@/data/products";

export default function ShopContent() {
    const [selectedProduct, setSelectedProduct] = useState<Product | null>(null);
    const [isModalOpen, setIsModalOpen] = useState(false);

    // Group products by category
    const productsByCategory = categories
        .filter(cat => cat !== "All")
        .map(category => ({
            category,
            items: products.filter(p => p.category === category)
        }))
        .filter(group => group.items.length > 0);

    const handleProductClick = (product: Product) => {
        setSelectedProduct(product);
        setIsModalOpen(true);
    };

    return (
        <div className={styles.container}>
            {productsByCategory.map((group) => (
                <section key={group.category} className={styles.categorySection}>
                    <h2 className={styles.categoryTitle}>{group.category}</h2>
                    <div className={styles.grid}>
                        {group.items.map((product) => (
                            <ProductCard
                                key={product.id}
                                product={product}
                                onClick={() => handleProductClick(product)}
                            />
                        ))}
                    </div>
                </section>
            ))}

            <ProductDetailsModal
                product={selectedProduct}
                isOpen={isModalOpen}
                onClose={() => setIsModalOpen(false)}
            />
        </div>
    );
}
