import styles from "@/components/StaticPage.module.css";

export default function PrivacyPage() {
    return (
        <div className={styles.container}>
            <h1 className={styles.title}>Privacy Policy</h1>

            <div className={styles.section}>
                <p className={styles.text}>At ChiggaExpress.com, we value your privacy and are committed to protecting your personal information.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Information We Collect</h2>
                <p className={styles.text}>We may collect personal information such as your name, email address, phone number, shipping address, and payment details when you place an order or contact us.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>How We Use Your Information</h2>
                <ul className={styles.list}>
                    <li>To process and deliver orders</li>
                    <li>To communicate with you about your orders or inquiries</li>
                    <li>To improve our website and services</li>
                    <li>To comply with legal obligations</li>
                </ul>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Data Protection</h2>
                <p className={styles.text}>We take appropriate security measures to protect your personal information from unauthorized access, misuse, or disclosure.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Third-Party Services</h2>
                <p className={styles.text}>We may use trusted third-party services (such as payment processors) to complete transactions. These services are required to protect your information.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Cookies</h2>
                <p className={styles.text}>ChiggaExpress.com may use cookies to enhance user experience and analyze website performance.</p>
            </div>

            <div className={styles.section}>
                <h2 className={styles.sectionTitle}>Contact Us</h2>
                <p className={styles.text}>If you have any questions about this Privacy Policy, please contact us:</p>
                <div className={styles.contactInfo}>
                    <p><strong>Email:</strong> chigoziemediahouse@gmail.com</p>
                    <p><strong>WhatsApp:</strong> +1 (405) 761-8287</p>
                    <p><strong>Address:</strong> 2444 West Eubanks Street, Oklahoma City, USA</p>
                </div>
            </div>
        </div>
    );
}
