import Link from "next/link";
import styles from "./page.module.css";
import ProductCard from "@/components/ProductCard";
import { products } from "@/data/products";
import { ArrowRight, Star } from "lucide-react";

export default function Home() {
  const featuredProducts = products;

  return (
    <div className={styles.container}>
      {/* Sidebar + Main Content Layout */}
      <div className={styles.mainLayout}>

        {/* Sidebar Banner (Zank Style) */}
        <aside className={styles.sidebar}>
          <div className={styles.sidebarContent}>
            <span className={styles.verticalText}>NEW ARRIVALS</span>
            <div className={styles.sidebarImage}>
              <img src="https://images.unsplash.com/photo-1616348436168-de43ad0db179?auto=format&fit=crop&q=80&w=600" alt="New Arrival" />
            </div>
            <Link href="/shop" className={styles.sidebarLink}>
              CHECK <br /> IT OUT
            </Link>
          </div>
        </aside>

        {/* Main Content Area */}
        <main className={styles.mainContent}>

          {/* Hero Section */}
          <section className={styles.hero}>
            <div className={styles.heroContent}>
              <h1 className={styles.heroTitle}>
                Future <br />
                Tech.
              </h1>
              <p className={styles.heroText}>
                Discover the latest in high-performance electronics.
              </p>
              <Link href="/shop" className={styles.ctaButton}>
                Shop Now <ArrowRight size={20} />
              </Link>
            </div>
            <div className={styles.heroImage}>
              <img src="https://images.unsplash.com/photo-1550009158-9ebf69173e03?auto=format&fit=crop&q=80&w=1200" alt="Modern Electronics" />
            </div>
          </section>

          {/* Features (Colorful) */}
          <section className={styles.features}>
            <div className={styles.featureItem} style={{ background: '#fff3e0' }}>
              <h3>🚀 Fast Shipping</h3>
              <p>Get your gadgets delivered in record time, anywhere.</p>
            </div>
            <div className={styles.featureItem} style={{ background: '#e3f2fd' }}>
              <h3>🛡️ Secure Payment</h3>
              <p>100% secure transactions with top-tier encryption.</p>
            </div>
            <div className={styles.featureItem} style={{ background: '#fce4ec' }}>
              <h3>🎧 Premium Quality</h3>
              <p>Only the best brands and authentic products.</p>
            </div>
          </section>

          {/* Product Grid */}
          <section className={styles.section}>
            <div className={styles.sectionHeader}>
              <h2 className={styles.sectionTitle}>Featured Products</h2>
              <Link href="/shop" className={styles.viewAll}>
                View All <ArrowRight size={16} />
              </Link>
            </div>
            <div className={styles.grid}>
              {featuredProducts.map((product) => (
                <ProductCard key={product.id} product={product} />
              ))}
            </div>
          </section>

          {/* Newsletter Banner */}
          <section className={styles.banner}>
            <div className={styles.bannerContent}>
              <h2>Join the Future of Tech</h2>
              <p>Subscribe to our newsletter for exclusive drops.</p>
              <form className={styles.newsletterForm}>
                <input type="email" placeholder="Enter your email" />
                <button type="submit">Subscribe</button>
              </form>
            </div>
          </section>

        </main>
      </div>
    </div>
  );
}
