import Link from "next/link";
import { CheckCircle } from "lucide-react";
import styles from "./page.module.css"; // Reuse checkout styling for container? Or inline style/new module.

export default function SuccessPage() {
    return (
        <div style={{
            maxWidth: 600,
            margin: "4rem auto",
            textAlign: "center",
            padding: "2rem",
        }}>
            <CheckCircle size={80} color="#10b981" style={{ marginBottom: "1rem" }} />
            <h1 style={{ fontSize: "2.5rem", fontWeight: 800, marginBottom: "1rem" }}>Order Confirmed!</h1>
            <p style={{ color: "#555", marginBottom: "2rem", lineHeight: 1.6 }}>
                Thank you for your purchase. Your order has been received and will be processed shortly.
                A confirmation email has been sent to you.
            </p>
            <Link href="/" style={{
                display: "inline-block",
                background: "black",
                color: "white",
                padding: "1rem 2rem",
                borderRadius: "50px",
                fontWeight: 600
            }}>
                Return Home
            </Link>
        </div>
    );
}
