"use client";
import React, { useState } from "react";
import { useCart } from "@/context/CartContext";
import styles from "./page.module.css";
import { useRouter } from "next/navigation";
import StripeWrapper from "@/components/StripeWrapper";

export default function CheckoutPage() {
    const { items, total, clearCart } = useCart();
    const router = useRouter();
    const [loading, setLoading] = useState(false);

    if (items.length === 0) {
        if (typeof window !== "undefined") router.push("/cart");
        return null;
    }

    return (
        <div className={styles.container}>
            <h1 className={styles.title}>Checkout</h1>
            <div className={styles.layout}>
                {/* Form now handles shipping only, Payment handled by Stripe Component */}
                <div className={styles.form}>
                    <div className={styles.section}>
                        <h2>Shipping Information</h2>
                        <div className={styles.grid}>
                            <div className={styles.field}>
                                <label>Full Name</label>
                                <input type="text" required placeholder="John Doe" />
                            </div>
                            <div className={styles.field}>
                                <label>Email</label>
                                <input type="email" required placeholder="john@example.com" />
                            </div>
                        </div>
                        <div className={styles.field}>
                            <label>Address</label>
                            <input type="text" required placeholder="123 Main St" />
                        </div>
                        <div className={styles.grid}>
                            <div className={styles.field}>
                                <label>City</label>
                                <input type="text" required placeholder="New York" />
                            </div>
                            <div className={styles.field}>
                                <label>Zip Code</label>
                                <input type="text" required placeholder="10001" />
                            </div>
                        </div>
                    </div>

                    <div className={styles.section}>
                        <h2>Payment Method</h2>
                        <div className={styles.stripeContainer}>
                            <StripeWrapper amount={total} />
                        </div>
                    </div>
                </div>

                <div className={styles.summary}>
                    <h3>Order Summary</h3>
                    <div className={styles.itemList}>
                        {items.map(item => (
                            <div key={item.id} className={styles.item}>
                                <span>{item.name} x {item.quantity}</span>
                                <span>${(item.price * item.quantity).toFixed(2)}</span>
                            </div>
                        ))}
                    </div>
                    <div className={styles.divider} />
                    <div className={styles.total}>
                        <span>Total</span>
                        <span>${total.toFixed(2)}</span>
                    </div>
                </div>
            </div>
        </div>
    );
}
