"use client";
import React from "react";
import { useCart } from "@/context/CartContext";
import styles from "./page.module.css";
import Link from "next/link";
import { Trash2, Plus, Minus, ArrowRight } from "lucide-react";

export default function CartPage() {
    const { items, updateQuantity, removeItem, total } = useCart();

    if (items.length === 0) {
        return (
            <div className={styles.emptyContainer}>
                <h2>Your Cart is Empty</h2>
                <p>Looks like you haven't added any gadgets yet.</p>
                <Link href="/shop" className={styles.continueBtn}>Continue Shopping</Link>
            </div>
        );
    }

    return (
        <div className={styles.container}>
            <h1 className={styles.title}>Shopping Cart</h1>
            <div className={styles.layout}>
                <div className={styles.items}>
                    {items.map(item => (
                        <div key={item.id} className={styles.item}>
                            <div className={styles.imageWrapper}>
                                <img src={item.image} alt={item.name} className={styles.image} />
                            </div>
                            <div className={styles.details}>
                                <Link href={`/product/${item.id}`} className={styles.itemName}>
                                    {item.name}
                                </Link>
                                <p className={styles.itemPrice}>${item.price}</p>
                                <span className={styles.itemCat}>{item.category}</span>
                            </div>
                            <div className={styles.actions}>
                                <div className={styles.qty}>
                                    <button onClick={() => updateQuantity(item.id, item.quantity - 1)} className={styles.qtyBtn}><Minus size={16} /></button>
                                    <span className={styles.qtyVal}>{item.quantity}</span>
                                    <button onClick={() => updateQuantity(item.id, item.quantity + 1)} className={styles.qtyBtn}><Plus size={16} /></button>
                                </div>
                                <div className={styles.itemTotal}>${(item.price * item.quantity).toFixed(2)}</div>
                                <button onClick={() => removeItem(item.id)} className={styles.remove} aria-label="Remove item">
                                    <Trash2 size={18} />
                                </button>
                            </div>
                        </div>
                    ))}
                </div>
                <div className={styles.summary}>
                    <h3>Order Summary</h3>
                    <div className={styles.row}>
                        <span>Subtotal</span>
                        <span>${total.toFixed(2)}</span>
                    </div>
                    <div className={styles.row}>
                        <span>Shipping</span>
                        <span>Free</span>
                    </div>
                    <div className={styles.divider} />
                    <div className={`${styles.row} ${styles.total}`}>
                        <span>Total</span>
                        <span>${total.toFixed(2)}</span>
                    </div>
                    <Link href="/checkout" className={styles.checkoutBtn}>
                        Proceed to Checkout <ArrowRight size={18} />
                    </Link>
                </div>
            </div>
        </div>
    );
}
