"use client";
import React, { useState } from "react";
import { useAuth } from "@/context/AuthContext";
import styles from "./page.module.css";
import { User, Package, LogOut } from "lucide-react";

export default function AccountPage() {
    const { user, login, signup, logout, isLoading } = useAuth();
    const [isLogin, setIsLogin] = useState(true);
    const [email, setEmail] = useState("");
    const [password, setPassword] = useState("");
    const [name, setName] = useState("");
    const [error, setError] = useState("");

    if (isLoading) return <div className={styles.loading}>Loading...</div>;

    if (user) {
        return (
            <div className={styles.container}>
                <div className={styles.header}>
                    <h1>My Account</h1>
                    <button onClick={logout} className={styles.logoutBtn}>
                        <LogOut size={18} /> Logout
                    </button>
                </div>

                <div className={styles.grid}>
                    <div className={styles.card}>
                        <div className={styles.userIcon}>
                            <User size={40} />
                        </div>
                        <h2>{user.name}</h2>
                        <p>{user.email}</p>
                        <div className={styles.badge}>{user.role}</div>
                    </div>

                    <div className={styles.history}>
                        <h3>Order History</h3>
                        <div className={styles.orderList}>
                            {/* Mock Orders */}
                            <div className={styles.order}>
                                <div className={styles.orderHeader}>
                                    <span className={styles.orderId}>#ORDER-1234</span>
                                    <span className={styles.status}>Delivered</span>
                                </div>
                                <div className={styles.orderDate}>Dec 20, 2024</div>
                                <div className={styles.orderTotal}>Total: $1,299.00</div>
                            </div>
                            <div className={styles.order}>
                                <div className={styles.orderHeader}>
                                    <span className={styles.orderId}>#ORDER-5678</span>
                                    <span className={styles.status}>Processing</span>
                                </div>
                                <div className={styles.orderDate}>Dec 25, 2024</div>
                                <div className={styles.orderTotal}>Total: $39.00</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        );
    }

    const handleSubmit = async (e: React.FormEvent) => {
        e.preventDefault();
        setError("");
        try {
            if (isLogin) {
                await login(email, password);
            } else {
                await signup(name, email, password);
            }
        } catch (err: any) {
            setError(err.message || "An error occurred");
        }
    };

    return (
        <div className={styles.authContainer}>
            <div className={styles.authBox}>
                <h1>{isLogin ? "Welcome Back" : "Create Account"}</h1>
                <p className={styles.subtitle}>
                    {isLogin ? "Login to access your orders" : "Join ChiggaExpress today"}
                </p>

                <form onSubmit={handleSubmit} className={styles.form}>
                    {!isLogin && (
                        <div className={styles.field}>
                            <label>Full Name</label>
                            <input
                                type="text"
                                required
                                value={name}
                                onChange={e => setName(e.target.value)}
                                placeholder="John Doe"
                            />
                        </div>
                    )}
                    <div className={styles.field}>
                        <label>Email Address</label>
                        <input
                            type="email"
                            required
                            value={email}
                            onChange={e => setEmail(e.target.value)}
                            placeholder="john@example.com"
                        />
                    </div>
                    <div className={styles.field}>
                        <label>Password</label>
                        <input
                            type="password"
                            required
                            value={password}
                            onChange={e => setPassword(e.target.value)}
                            placeholder="••••••••"
                        />
                    </div>

                    {error && <div className={styles.error}>{error}</div>}

                    <button type="submit" className={styles.submitBtn}>
                        {isLogin ? "Login" : "Sign Up"}
                    </button>
                </form>

                <div className={styles.toggle}>
                    {isLogin ? "Don't have an account? " : "Already have an account? "}
                    <button onClick={() => setIsLogin(!isLogin)}>
                        {isLogin ? "Sign Up" : "Login"}
                    </button>
                </div>
            </div>
        </div>
    );
}
